#include "Utilities.h"

#ifdef __APPLE__
#include <GLUT/glut.h>
#include <OpenGL/gl.h>
#else
#include <GL/glut.h>
#include <GL/gl.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "Matrix.h"
#include "Quaternion.h"

void applyQuaternion(struct Quaternion quaternion) {
	Matrix matrix;
	
	matrix = Quaternion_toMatrix(quaternion);
	glMultMatrixf(matrix.m);
}

void drawGlutString(int rasterPosX, int rasterPosY, char * string) {
	int length, charIndex;
	
	glRasterPos2i(rasterPosX, rasterPosY);
	length = strlen(string);
	for (charIndex = 0; charIndex < length; charIndex++) {
		glutBitmapCharacter(GLUT_BITMAP_8_BY_13, string[charIndex]);
	}
}
